#define _QCAP_LABVIEW_IMPORT
typedef int                 BOOL;
#define FALSE 0
#define TRUE 1
typedef int INT;
#include "filerecorddlg.h"
#include "ui_filerecorddlg.h"
#include "channelwindow.h"

#include "QCAP.H"

FileRecordDlg::FileRecordDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FileRecordDlg)
{
    ui->setupUi(this);

    this->setWindowTitle("FILE RECORD DIALOG");

    this->setMinimumSize(707,406);

    this->setMaximumSize(707,406);

    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    ui->BTN_StopRecord11->setEnabled(false);

    ui->BTN_StopRecord12->setEnabled(false);

    ui->BTN_StopRecord21->setEnabled(false);

    ui->BTN_StopRecord22->setEnabled(false);

    ui->BTN_StopRecord31->setEnabled(false);

    ui->BTN_StopRecord32->setEnabled(false);

    ui->BTN_StopRecord41->setEnabled(false);

    ui->BTN_StopRecord42->setEnabled(false);

    ui->checkBox_AVI11->setChecked(false);

    ui->checkBox_AVI12->setChecked(false);

    ui->checkBox_AVI21->setChecked(false);

    ui->checkBox_AVI22->setChecked(false);

    ui->checkBox_AVI31->setChecked(false);

    ui->checkBox_AVI32->setChecked(false);

    ui->checkBox_AVI41->setChecked(false);

    ui->checkBox_AVI42->setChecked(false);

    ui->checkBox_MP411->setChecked(true);

    ui->checkBox_MP412->setChecked(true);

    ui->checkBox_MP421->setChecked(true);

    ui->checkBox_MP422->setChecked(true);

    ui->checkBox_MP431->setChecked(true);

    ui->checkBox_MP432->setChecked(true);

    ui->checkBox_MP441->setChecked(true);

    ui->checkBox_MP442->setChecked(true);

    ui->checkBox_GPU11->setChecked(true);

    ui->checkBox_GPU12->setChecked(true);

    ui->checkBox_GPU21->setChecked(true);

    ui->checkBox_GPU22->setChecked(true);

    ui->checkBox_GPU31->setChecked(true);

    ui->checkBox_GPU32->setChecked(true);

    ui->checkBox_GPU41->setChecked(true);

    ui->checkBox_GPU42->setChecked(true);

    ui->RecordPath11->setText( SC510dlg->path + QString("/record_1_1.mp4"));

    ui->RecordPath12->setText( SC510dlg->path + QString("/record_1_2.mp4"));

    ui->RecordPath21->setText( SC510dlg->path + QString("/record_2_1.mp4"));

    ui->RecordPath22->setText( SC510dlg->path + QString("/record_2_2.mp4"));

    ui->RecordPath31->setText( SC510dlg->path + QString("/record_3_1.mp4"));

    ui->RecordPath32->setText( SC510dlg->path + QString("/record_3_2.mp4"));

    ui->RecordPath41->setText( SC510dlg->path + QString("/record_4_1.mp4"));

    ui->RecordPath42->setText( SC510dlg->path + QString("/record_4_2.mp4"));

    if( SC510dlg->m_hVideoDevice[0] == 0)
    {
        ui->BTN_StartRecord11->setEnabled(false);

        ui->BTN_StartRecord12->setEnabled(false);
    }

    if( SC510dlg->m_hVideoDevice[1] == 0)
    {
        ui->BTN_StartRecord21->setEnabled(false);

        ui->BTN_StartRecord22->setEnabled(false);
    }

    if( SC510dlg->m_hVideoDevice[2] == 0)
    {
        ui->BTN_StartRecord31->setEnabled(false);

        ui->BTN_StartRecord32->setEnabled(false);
    }

    if( SC510dlg->m_hVideoDevice[3] == 0)
    {
        ui->BTN_StartRecord41->setEnabled(false);

        ui->BTN_StartRecord42->setEnabled(false);
    }

    for(ULONG i = 0 ; i < 8 ; i++)
    {
        m_IsRecord[i] = false;
    }
}

FileRecordDlg::~FileRecordDlg()
{
    delete ui;
}

void FileRecordDlg::on_checkBox_AVI11_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0)
    {
        ui->checkBox_MP411->setChecked(true);

        ui->RecordPath11->setText( SC510dlg->path + QString("/record_1_1.mp4"));
    }
    else
    {
        ui->checkBox_MP411->setChecked(false);

        ui->RecordPath11->setText( SC510dlg->path + QString("/record_1_1.avi"));
    }
}

void FileRecordDlg::on_checkBox_AVI12_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0)
    {
        ui->checkBox_MP412->setChecked(true);

        ui->RecordPath12->setText( SC510dlg->path + QString("/record_1_2.mp4"));
    }
    else
    {
        ui->checkBox_MP412->setChecked(false);

        ui->RecordPath12->setText( SC510dlg->path + QString("/record_1_2.avi"));
    }
}

void FileRecordDlg::on_checkBox_AVI21_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0)
    {
        ui->checkBox_MP421->setChecked(true);

        ui->RecordPath21->setText( SC510dlg->path + QString("/record_2_1.mp4"));
    }
    else
    {
        ui->checkBox_MP421->setChecked(false);

        ui->RecordPath21->setText( SC510dlg->path + QString("/record_2_1.avi"));
    }
}

void FileRecordDlg::on_checkBox_AVI22_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0)
    {
        ui->checkBox_MP422->setChecked(true);

        ui->RecordPath22->setText( SC510dlg->path + QString("/record_2_2.mp4"));
    }
    else
    {
        ui->checkBox_MP422->setChecked(false);

        ui->RecordPath22->setText( SC510dlg->path + QString("/record_2_2.avi"));
    }
}

void FileRecordDlg::on_checkBox_AVI31_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0)
    {
        ui->checkBox_MP431->setChecked(true);

        ui->RecordPath31->setText( SC510dlg->path + QString("/record_3_1.mp4"));
    }
    else
    {
        ui->checkBox_MP431->setChecked(false);

        ui->RecordPath31->setText( SC510dlg->path + QString("/record_3_1.avi"));
    }
}

void FileRecordDlg::on_checkBox_AVI32_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0)
    {
        ui->checkBox_MP432->setChecked(true);

        ui->RecordPath32->setText( SC510dlg->path + QString("/record_3_2.mp4"));
    }
    else
    {
        ui->checkBox_MP432->setChecked(false);

        ui->RecordPath32->setText( SC510dlg->path + QString("/record_3_2.avi"));
    }
}

void FileRecordDlg::on_checkBox_AVI41_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0)
    {
        ui->checkBox_MP441->setChecked(true);

        ui->RecordPath41->setText( SC510dlg->path + QString("/record_4_1.mp4"));
    }
    else
    {
        ui->checkBox_MP441->setChecked(false);

        ui->RecordPath41->setText( SC510dlg->path + QString("/record_4_1.avi"));
    }
}

void FileRecordDlg::on_checkBox_AVI42_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0)
    {
        ui->checkBox_MP442->setChecked(true);

        ui->RecordPath42->setText( SC510dlg->path + QString("/record_4_2.mp4"));
    }
    else
    {
        ui->checkBox_MP442->setChecked(false);

        ui->RecordPath42->setText( SC510dlg->path + QString("/record_4_2.avi"));
    }
}

void FileRecordDlg::on_checkBox_MP411_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_AVI11->setChecked(true);

        ui->RecordPath11->setText( SC510dlg->path + QString("/record_1_1.avi"));
    }
    else
    {
        ui->checkBox_AVI11->setChecked(false);

        ui->RecordPath11->setText( SC510dlg->path + QString("/record_1_1.mp4"));
    }
}

void FileRecordDlg::on_checkBox_MP412_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_AVI12->setChecked(true);

        ui->RecordPath12->setText( SC510dlg->path + QString("/record_1_2.avi"));
    }
    else
    {
        ui->checkBox_AVI12->setChecked(false);

        ui->RecordPath12->setText( SC510dlg->path + QString("/record_1_2.mp4"));
    }
}

void FileRecordDlg::on_checkBox_MP421_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_AVI21->setChecked(true);

        ui->RecordPath21->setText( SC510dlg->path + QString("/record_2_1.avi"));
    }
    else
    {
        ui->checkBox_AVI21->setChecked(false);

        ui->RecordPath21->setText( SC510dlg->path + QString("/record_2_1.mp4"));
    }
}

void FileRecordDlg::on_checkBox_MP422_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_AVI22->setChecked(true);

        ui->RecordPath22->setText( SC510dlg->path + QString("/record_2_2.avi"));
    }
    else
    {
        ui->checkBox_AVI22->setChecked(false);

        ui->RecordPath22->setText( SC510dlg->path + QString("/record_2_2.mp4"));
    }
}

void FileRecordDlg::on_checkBox_MP431_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_AVI31->setChecked(true);

        ui->RecordPath31->setText( SC510dlg->path + QString("/record_3_1.avi"));
    }
    else
    {
        ui->checkBox_AVI31->setChecked(false);

        ui->RecordPath31->setText( SC510dlg->path + QString("/record_3_1.mp4"));
    }
}

void FileRecordDlg::on_checkBox_MP432_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_AVI32->setChecked(true);

        ui->RecordPath32->setText( SC510dlg->path + QString("/record_3_2.avi"));
    }
    else
    {
        ui->checkBox_AVI32->setChecked(false);

        ui->RecordPath32->setText( SC510dlg->path + QString("/record_3_2.mp4"));
    }
}

void FileRecordDlg::on_checkBox_MP441_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_AVI41->setChecked(true);

        ui->RecordPath41->setText( SC510dlg->path + QString("/record_4_1.avi"));
    }
    else
    {
        ui->checkBox_AVI41->setChecked(false);

        ui->RecordPath41->setText( SC510dlg->path + QString("/record_4_1.mp4"));
    }
}

void FileRecordDlg::on_checkBox_MP442_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_AVI42->setChecked(true);

        ui->RecordPath42->setText( SC510dlg->path + QString("/record_4_2.avi"));
    }
    else
    {
        ui->checkBox_AVI42->setChecked(false);

        ui->RecordPath42->setText( SC510dlg->path + QString("/record_4_2.mp4"));
    }
}

void FileRecordDlg::on_BTN_StartRecord11_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( ui->checkBox_AVI11->isChecked() )
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[0], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }
    else
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[0], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    if( ui->checkBox_GPU11->isChecked() )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[0], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }
    else
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[0], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }

    QByteArray record1_path_ByteArray = ui->RecordPath11->text().toLocal8Bit();

    CHAR* psz = record1_path_ByteArray.data();

    QCAP_START_RECORD( SC510dlg->m_hVideoDevice[0], 0, psz);

    m_IsRecord[0] = true;

    ui->BTN_StartRecord11->setEnabled(false);

    ui->BTN_StopRecord11->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord11_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if(  m_IsRecord[0] == true )
    {
        QCAP_STOP_RECORD( SC510dlg->m_hVideoDevice[0], 0 );

        m_IsRecord[0] = false;

        ui->BTN_StartRecord11->setEnabled(true);

        ui->BTN_StopRecord11->setEnabled(false);
    }
}

void FileRecordDlg::on_BTN_StartRecord12_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( ui->checkBox_AVI12->isChecked() )
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[0], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }
    else
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[0], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    if( ui->checkBox_GPU12->isChecked() )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[0], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
    }
    else
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[0], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
    }

    QByteArray record1_path_ByteArray = ui->RecordPath12->text().toLocal8Bit();

    CHAR* psz = record1_path_ByteArray.data();

    QCAP_START_RECORD( SC510dlg->m_hVideoDevice[0], 1, psz);

    m_IsRecord[1] = true;

    ui->BTN_StartRecord12->setEnabled(false);

    ui->BTN_StopRecord12->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord12_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if(  m_IsRecord[1] == true )
    {
        QCAP_STOP_RECORD( SC510dlg->m_hVideoDevice[0], 1 );

        m_IsRecord[1] = false;

        ui->BTN_StartRecord12->setEnabled(true);

        ui->BTN_StopRecord12->setEnabled(false);
    }
}

void FileRecordDlg::on_BTN_StartRecord21_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( ui->checkBox_AVI21->isChecked() )
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[1], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }
    else
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[1], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    if( ui->checkBox_GPU21->isChecked() )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[1], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }
    else
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[1], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }

    QByteArray record1_path_ByteArray = ui->RecordPath21->text().toLocal8Bit();

    CHAR* psz = record1_path_ByteArray.data();

    QCAP_START_RECORD( SC510dlg->m_hVideoDevice[1], 0, psz);

    m_IsRecord[2] = true;

    ui->BTN_StartRecord21->setEnabled(false);

    ui->BTN_StopRecord21->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord21_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if(  m_IsRecord[2] == true )
    {
        QCAP_STOP_RECORD( SC510dlg->m_hVideoDevice[1], 0 );

        m_IsRecord[2] = false;

        ui->BTN_StartRecord21->setEnabled(true);

        ui->BTN_StopRecord21->setEnabled(false);
    }
}

void FileRecordDlg::on_BTN_StartRecord22_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( ui->checkBox_AVI22->isChecked() )
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[1], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }
    else
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[1], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    if( ui->checkBox_GPU22->isChecked() )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[1], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
    }
    else
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[1], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
    }

    QByteArray record1_path_ByteArray = ui->RecordPath22->text().toLocal8Bit();

    CHAR* psz = record1_path_ByteArray.data();

    QCAP_START_RECORD( SC510dlg->m_hVideoDevice[1], 1, psz);

    m_IsRecord[3] = true;

    ui->BTN_StartRecord22->setEnabled(false);

    ui->BTN_StopRecord22->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord22_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if(  m_IsRecord[3] == true )
    {
        QCAP_STOP_RECORD( SC510dlg->m_hVideoDevice[1], 1 );

        m_IsRecord[3] = false;

        ui->BTN_StartRecord22->setEnabled(true);

        ui->BTN_StopRecord22->setEnabled(false);
    }
}

void FileRecordDlg::on_BTN_StartRecord31_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( ui->checkBox_AVI31->isChecked() )
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[2], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }
    else
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[2], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    if( ui->checkBox_GPU31->isChecked() )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[2], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }
    else
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[2], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }

    QByteArray record1_path_ByteArray = ui->RecordPath31->text().toLocal8Bit();

    CHAR* psz = record1_path_ByteArray.data();

    QCAP_START_RECORD( SC510dlg->m_hVideoDevice[2], 0, psz);

    m_IsRecord[4] = true;

    ui->BTN_StartRecord31->setEnabled(false);

    ui->BTN_StopRecord31->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord31_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if(  m_IsRecord[4] == true )
    {
        QCAP_STOP_RECORD( SC510dlg->m_hVideoDevice[2], 0 );

        m_IsRecord[4] = false;

        ui->BTN_StartRecord31->setEnabled(true);

        ui->BTN_StopRecord31->setEnabled(false);
    }
}

void FileRecordDlg::on_BTN_StartRecord32_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( ui->checkBox_AVI32->isChecked() )
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[2], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }
    else
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[2], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    if( ui->checkBox_GPU32->isChecked() )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[2], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
    }
    else
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[2], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
    }

    QByteArray record1_path_ByteArray = ui->RecordPath32->text().toLocal8Bit();

    CHAR* psz = record1_path_ByteArray.data();

    QCAP_START_RECORD( SC510dlg->m_hVideoDevice[2], 1, psz);

    m_IsRecord[5] = true;

    ui->BTN_StartRecord32->setEnabled(false);

    ui->BTN_StopRecord32->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord32_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if(  m_IsRecord[5] == true )
    {
        QCAP_STOP_RECORD( SC510dlg->m_hVideoDevice[2], 1 );

        m_IsRecord[5] = false;

        ui->BTN_StartRecord32->setEnabled(true);

        ui->BTN_StopRecord32->setEnabled(false);
    }
}

void FileRecordDlg::on_BTN_StartRecord41_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( ui->checkBox_AVI41->isChecked() )
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[3], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }
    else
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[3], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    if( ui->checkBox_GPU41->isChecked() )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[3], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }
    else
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[3], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }

    QByteArray record1_path_ByteArray = ui->RecordPath41->text().toLocal8Bit();

    CHAR* psz = record1_path_ByteArray.data();

    QCAP_START_RECORD( SC510dlg->m_hVideoDevice[3], 0, psz);

    m_IsRecord[6] = true;

    ui->BTN_StartRecord41->setEnabled(false);

    ui->BTN_StopRecord41->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord41_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if(  m_IsRecord[6] == true )
    {
        QCAP_STOP_RECORD( SC510dlg->m_hVideoDevice[3], 0 );

        m_IsRecord[6] = false;

        ui->BTN_StartRecord41->setEnabled(true);

        ui->BTN_StopRecord41->setEnabled(false);
    }
}

void FileRecordDlg::on_BTN_StartRecord42_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( ui->checkBox_AVI42->isChecked() )
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[3], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }
    else
    {
        QCAP_SET_AUDIO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[3], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    if( ui->checkBox_GPU42->isChecked() )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[3], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
    }
    else
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( SC510dlg->m_hVideoDevice[3], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
    }

    QByteArray record1_path_ByteArray = ui->RecordPath42->text().toLocal8Bit();

    CHAR* psz = record1_path_ByteArray.data();

    QCAP_START_RECORD( SC510dlg->m_hVideoDevice[3], 1, psz);

    m_IsRecord[7] = true;

    ui->BTN_StartRecord42->setEnabled(false);

    ui->BTN_StopRecord42->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord42_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if(  m_IsRecord[7] == true )
    {
        QCAP_STOP_RECORD( SC510dlg->m_hVideoDevice[3], 1 );

        m_IsRecord[7] = true;

        ui->BTN_StartRecord42->setEnabled(true);

        ui->BTN_StopRecord42->setEnabled(false);
    }
}

void FileRecordDlg::closeEvent ( QCloseEvent * e )
{
    on_BTN_StopRecord11_clicked();

    on_BTN_StopRecord12_clicked();

    on_BTN_StopRecord21_clicked();

    on_BTN_StopRecord22_clicked();

    on_BTN_StopRecord31_clicked();

    on_BTN_StopRecord32_clicked();

    on_BTN_StopRecord41_clicked();

    on_BTN_StopRecord42_clicked();
}
